@extends('dashboard.layout.master')

@section('content')
    <!--begin::Card-->
    <div class="card card-custom gutter-b">
        <div class="card-header flex-wrap py-3">
            <div class="card-title">
                <h3 class="card-label">{{ $title }}</h3>
            </div>
            <div class="card-toolbar">
                <!--begin::Button-->
                <a href="{{ route('dashboard.vouchers.create') }}" class="btn btn-primary font-weight-bolder">
                    <span class="svg-icon svg-icon-md">
                        <!--begin::Svg Icon | path:assets/media/svg/icons/Design/Flatten.svg-->
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                            <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                <rect x="0" y="0" width="24" height="24" />
                                <circle fill="#000000" cx="9" cy="15" r="6" />
                                <path d="M8.8012943,7.00241953 C9.83837775,5.20768121 11.7781543,4 14,4 C17.3137085,4 20,6.6862915 20,10 C20,12.2218457 18.7923188,14.1616223 16.9975805,15.1987057 C16.9991904,15.1326658 17,15.0664274 17,15 C17,10.581722 13.418278,7 9,7 C8.93357256,7 8.86733422,7.00080962 8.8012943,7.00241953 Z" fill="#000000" opacity="0.3" />
                            </g>
                        </svg>
                        <!--end::Svg Icon-->
                    </span>New Record
                </a>
                <!--end::Button-->
            </div>
        </div>
        <div class="card-body">
            <!--begin: Datatable-->
            <table class="table table-bordered table-checkable" id="datatable1">
                <thead>
                    <tr>
                        <th>#</th>
                        <th>Code</th>
                        <th>Start At</th>
                        <th>Ended At</th>
                        <th>Status</th>
                        <th>Location</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($voucher as $key => $voucher)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $voucher->code }}</td>
                            <td>{{ $voucher->started_at }}</td>
                            <td>{{ $voucher->ended_at }}</td>
                            <td>
                                @if($voucher->is_active)
                                    <span class="label label-success label-pill label-inline">Active</span>
                                @else
                                    <span class="label label-danger label-pill label-inline">Inactive</span>
                                @endif
                            </td>
                            <td>{{ $voucher->outlet->name }}</td>
                            <td>
                                <a href="{{ route('dashboard.vouchers.edit', $voucher->id) }}" class="btn btn-sm btn-info">Edit</a>
                                <a href="{{ route('dashboard.vouchers.destroy', $voucher->id) }}" class="btn btn-sm btn-danger btn-delete">Delete</a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <!--end: Datatable-->
        </div>
    </div>
    <!--end::Card-->
@endsection

@section('scripts')
    <script>
        $(function () {
            
            $('#datatable1').DataTable({
                responsive: true,
                aLengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, 'All']],
                pageLength: 50
            });

            $('#datatable1').on('click', '.btn-delete', function(event) {
                let $confirm = confirm('Are you sure?');
                if ($confirm) {
                    $.ajax({
                        url: $(this).attr('href'),
                        type: 'POST',
                        data: {_method: 'DELETE'},
                    }).done(function(response) {
                        if (response.code === 200) {
                            location.reload();
                        }
                        else {
                            alert('Something when wrong, please refresh your browser');
                        }
                    }).fail(function() {
                        console.log("error");
                    }).always(function() {
                        console.log("complete");
                    });
                }
                return false;
            });
        });
    </script>
@endsection
