<?php

namespace App\Http\Controllers\Dashboard\Data;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $users = User::query();

            return DataTables::eloquent($users)
                ->addColumn('action', function ($user) {
                    return '<a href="' . route('dashboard.users.edit', $user->id) . '" class="btn btn-sm btn-info">Edit</a>
                            <a href="' . route('dashboard.users.destroy', $user->id) . '" class="btn btn-sm btn-danger btn-delete">Delete</a>';
                })
                ->addIndexColumn()
                ->rawColumns(['action'])
                ->make(true);
        }

        $data['title'] = 'User';

        return view('dashboard.data.users.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['title'] = 'Create User';

        return view('dashboard.data.users.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inputs = $request->all();
        $inputs['owner_id'] = 1; // auth()->user()->owner_id
        $inputs['password'] = bcrypt($request->password);

        User::create($inputs);

        return redirect(route('dashboard.users.index'))->with([
            'success' => 'Success add new record'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = 'Edit User';
        $data['user'] = User::findOrFail($id);

        return view('dashboard.data.users.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $inputs = $request->all();
        $inputs['owner_id'] = 1; // auth()->user()->owner_id
        unset($inputs['password']);

        if (! is_null($request->password)) {
            $inputs['password'] = bcrypt($request->password);
        }

        User::findOrFail($id)->update($inputs);

        return redirect(route('dashboard.users.index'))->with([
            'success' => 'Success update record'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        User::findOrFail($id)->delete();

        return response()->json(['code' => 200]);
    }
}
