<?php

namespace App\Http\Controllers\Dashboard\Catalog;

use App\Http\Controllers\Controller;
use App\Models\ProductCategory;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class ProductCategoryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $productCategories = ProductCategory::query();

            return DataTables::eloquent($productCategories)
                ->addColumn('action', function ($productCategory) {
                    return '<a href="' . route('dashboard.product-categories.edit', $productCategory->id) . '" class="btn btn-sm btn-info">Edit</a>
                            <a href="' . route('dashboard.product-categories.destroy', $productCategory->id) . '" class="btn btn-sm btn-danger btn-delete">Delete</a>';
                })
                ->addIndexColumn()
                ->rawColumns(['action'])
                ->make(true);
        }

        $data['title'] = 'Product Category';

        return view('dashboard.catalog.product_categories.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['title'] = 'Create Product Category';

        return view('dashboard.catalog.product_categories.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inputs = $request->all();
        $inputs['store_id'] = 1; // auth()->user()->owner_id
        $inputs['outlet_id'] = 1; // auth()->user()->owner_id

        ProductCategory::create($inputs);

        return redirect(route('dashboard.product-categories.index'))->with([
            'success' => 'Success add new record'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = 'Edit Product Category';
        $data['productCategory'] = ProductCategory::findOrFail($id);

        return view('dashboard.catalog.product_categories.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $inputs = $request->all();
        $inputs['store_id'] = 1; // auth()->user()->owner_id
        $inputs['outlet_id'] = 1; // auth()->user()->owner_id

        ProductCategory::findOrFail($id)->update($inputs);

        return redirect(route('dashboard.product-categories.index'))->with([
            'success' => 'Success update record'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        ProductCategory::findOrFail($id)->delete();

        return response()->json(['code' => 200]);
    }
}
