<?php

namespace App\Http\Controllers\Dashboard\Business;

use App\Http\Controllers\Controller;
use App\Models\Outlet;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class OutletController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if ($request->ajax()) {
            $outlets = Outlet::query();

            return DataTables::eloquent($outlets)
                ->addColumn('action', function ($outlet) {
                    return '<a href="' . route('dashboard.outlets.edit', $outlet->id) . '" class="btn btn-sm btn-info">Edit</a>
                            <a href="' . route('dashboard.outlets.destroy', $outlet->id) . '" class="btn btn-sm btn-danger btn-delete">Delete</a>';
                })
                ->addIndexColumn()
                ->rawColumns(['action'])
                ->make(true);
        }

        $data['title'] = 'Outlet';

        return view('dashboard.business.outlets.index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $data['title'] = 'Create Outlet';

        return view('dashboard.business.outlets.create', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $inputs = $request->all();
        $inputs['store_id'] = 1; // auth()->user()->owner_id

        Outlet::create($inputs);

        return redirect(route('dashboard.outlets.index'))->with([
            'success' => 'Success add new record'
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data['title'] = 'Edit Outlet';
        $data['outlet'] = Outlet::findOrFail($id);

        return view('dashboard.business.outlets.edit', $data);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $inputs = $request->all();
        $inputs['store_id'] = 1; // auth()->user()->owner_id

        Outlet::findOrFail($id)->update($inputs);

        return redirect(route('dashboard.outlets.index'))->with([
            'success' => 'Success update record'
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Outlet::findOrFail($id)->delete();

        return response()->json(['code' => 200]);
    }
}
